//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.0
import QtGraphicalEffects 1.0

Rectangle {
    id : button

    property alias iconSource : icon.source
    property int   iconSize : 32
    property alias containsMouse : mouseArea.containsMouse
    property bool  down : false

    property ButtonStyle style : ButtonStyle {}
    property bool disableColorOverlay : false

    readonly property bool pressed : mouseArea.pressed || down

    signal clicked()

    width : 32
    height : 32

    color : {
        if (pressed) {
            return style.backgroundActiveColor;
        } else if (containsMouse) {
            return style.backgroundHoverColor;
        } else {
            return style.backgroundColor;
        }
    }

    Image {
        id : icon
        anchors.centerIn : parent
        width : button.iconSize
        height : button.iconSize
        visible : disableColorOverlay
    }

    ColorOverlay {
        visible : !disableColorOverlay
        source : icon
        anchors.fill : icon
        color : {
            if (pressed) {
                return style.iconActiveColor;
            } else if (containsMouse) {
                return style.iconHoverColor;
            } else {
                return style.iconColor;
            }
        }

        Behavior on color {
            ColorAnimation {
                duration : 100
            }
        }
    }

    MouseArea {
        id : mouseArea

        hoverEnabled : true
        anchors.fill : parent
        acceptedButtons : Qt.LeftButton
        cursorShape : Qt.PointingHandCursor
        onPressed : button.clicked()
    }

    Behavior on color {
        ColorAnimation {
            duration : 100
        }
    }
}
